`timescale 1ns / 1ps

module appax (
    input  [7:0] A,
    input  [7:0] B,
    input        Cin,
    output [7:0] Sum,
    output       Cout
);

    wire [7:0] P, G;
    wire [8:0] C;

    assign P = A ^ B;
    assign G = A & B;

    assign Sum[0] = P[0];
    assign Sum[1] = P[1];
    assign Sum[2] = P[2];
    assign Sum[3] = P[3];


    assign C[4] = G[3];


    wire G14, G15, G16, G17;
    wire P14, P15, P16, P17;

    assign G14 = G[4];
    assign P14 = P[4];

    assign G15 = G[5] | (P[5] & G[4]);
    assign P15 = P[5] & P[4];

    assign G16 = G[6] | (P[6] & G[5]);
    assign P16 = P[6] & P[5];

    assign G17 = G[7] | (P[7] & G[6]);
    assign P17 = P[7] & P[6];

    wire G26, G27;
    wire P26, P27;

    assign G26 = G16 | (P16 & G14);
    assign P26 = P16 & P14;

    assign G27 = G17 | (P17 & G15);
    assign P27 = P17 & P15;

 
    assign C[5] = G[4]  | (P[4]  & C[4]);
    assign C[6] = G15   | (P15   & C[4]);
    assign C[7] = G26   | (P26   & C[4]);
    assign C[8] = G27   | (P27   & C[4]);

  
    assign Sum[4] = P[4] ^ C[4];
    assign Sum[5] = P[5] ^ C[5];
    assign Sum[6] = P[6] ^ C[6];
    assign Sum[7] = P[7] ^ C[7];

    assign Cout = C[8];

endmodule
