module SAR (
    input  wire clk,
    input  wire Comparator,
    input  wire Start,
    output reg  [7:0] data,
    output reg  over
);

    reg [3:0] count;
    reg converting;

    always @(posedge clk) begin
        if (Start) begin
            
            data <= 8'b1000_0000; 
            count <= 7;
            converting <= 1'b1;
            over <= 0;
        end else if (converting) begin
            
            if (Comparator == 0) begin
                data[count] <= 1'b0; 
            end

            if (count == 0) begin
                
                converting <= 1'b0;
                over <= 1'b1;
            end else begin
                
                data[count-1] <= 1'b1;
                count <= count - 1;
            end
        end
    end
endmodule
