module top_module (
    input  wire        system_clock,   // system clock input
    input  wire        enable,         // enable signal
    input  wire [7:0]  setup,          // setup value
    input  wire        RO_clock,       // from 3-stage ring oscillator (SPICE in eSim)
    output wire [15:0] RO_clock_count  // final count output
);

    // Internal wire
    wire enable_sync;

    // Chip Clock Counter instance
    chip_clock_counter u1 (
        .system_clock(system_clock),
        .enable(enable),
        .setup(setup),
        .enable_sync(enable_sync)
    );

    // Ring Oscillator Counter instance
    RO_counter u2 (
        .RO_clock(RO_clock),
        .enable_sync(enable_sync),
        .RO_clock_count(RO_clock_count)
    );

endmodule