module chip_clock_counter (
    input wire system_clock,
    input wire enable,
    input wire [7:0] setup,   // setup time/count
    output reg enable_sync
);

    reg [7:0] count = 0;

    always @(posedge system_clock) begin
        if (enable) begin
            if (count < setup) begin
                count <= count + 1;
                enable_sync <= 1;
            end else begin
                enable_sync <= 0;
            end
        end else begin
            count <= 0;
            enable_sync <= 0;
        end
    end

endmodule