model JFETCSampr
import Modelica.Electrical.*;
Analog.Basic.Resistor rs1(R = 1e3);
Analog.Basic.Resistor rd1(R = 2.2e3);
Analog.Basic.Resistor rg1(R = 1e-3);
Analog.Basic.Resistor rl1(R = 10e3);
Analog.Basic.Capacitor c2(C = 10ue-15);
Analog.Basic.Capacitor c3(C = 1ue-15);
Analog.Sources.ConstantVoltage vdd1(V = 12);
Analog.Basic.Capacitor c1(C = 0.01ue-15);
Analog.Sources.SineVoltage vin1(offset = 0, V = 2, freqHz = 50, startTime = 0, phase = 0);
protected
Modelica.Electrical.Analog.Interfaces.Pin nnet-_c3-pad2_, nnet-_c1-pad1_, nnet-_c2-pad1_, ngnd, nnet-_rd1-pad1_, nnet-_c3-pad1_, nnet-_c1-pad2_;
equation
connect(rs1.p,nnet-_c2-pad1_);
connect(rs1.n,ngnd);
connect(rd1.p,nnet-_rd1-pad1_);
connect(rd1.n,nnet-_c3-pad2_);
connect(rg1.p,nnet-_c1-pad1_);
connect(rg1.n,ngnd);
connect(rl1.p,nnet-_c3-pad1_);
connect(rl1.n,ngnd);
connect(c2.p,nnet-_c2-pad1_);
connect(c2.n,ngnd);
connect(c3.p,nnet-_c3-pad1_);
connect(c3.n,nnet-_c3-pad2_);
connect(vdd1.p,nnet-_rd1-pad1_);
connect(vdd1.n,ngnd);
connect(c1.p,nnet-_c1-pad1_);
connect(c1.n,nnet-_c1-pad2_);
connect(vin1.p,nnet-_c1-pad2_);
connect(vin1.n,ngnd);
end JFETCSampr;
