`timescale 1ns/1ns

module lfsr_tb;

reg clk, reset;
wire [3:0] random;

lfsr dut (
  .clk(clk),
  .reset(reset),
  .random(random)
);

initial begin
  clk = 0;
  reset = 1;
  #10 reset = 0;
end

always #5 clk = ~clk;

initial begin
  $monitor("Time=%0d, Random=%b", $time, random);
  
  // Generate 20 clock cycles of pseudo-random output
  repeat (20) @(posedge clk) ;
  
  // End simulation
  $finish;
end

endmodule
