module lfsr(
  input clk,
  input reset,
  output reg [3:0] random
);

reg [3:0] lfsr_reg;

always @(posedge clk, posedge reset) begin
  if (reset) begin
    lfsr_reg <= 4'b0001;
    random <= lfsr_reg;
  end
  else begin
    lfsr_reg <= {lfsr_reg[2:0], lfsr_reg[3]^lfsr_reg[0]};
    random <= lfsr_reg;
  end
end

endmodule