\TLV_version 1d: tl-x.org
\SV
/* verilator lint_off UNUSED*/  /* verilator lint_off DECLFILENAME*/  /* verilator lint_off BLKSEQ*/  /* verilator lint_off WIDTH*/  /* verilator lint_off SELRANGE*/  /* verilator lint_off PINCONNECTEMPTY*/  /* verilator lint_off DEFPARAM*/  /* verilator lint_off IMPLICIT*/  /* verilator lint_off COMBDLY*/  /* verilator lint_off SYNCASYNCNET*/  /* verilator lint_off UNOPTFLAT */  /* verilator lint_off UNSIGNED*/  /* verilator lint_off CASEINCOMPLETE*/  /* verilator lint_off UNDRIVEN*/  /* verilator lint_off VARHIDDEN*/  /* verilator lint_off CASEX*/  /* verilator lint_off CASEOVERLAP*/  /* verilator lint_off PINMISSING*/  /* verilator lint_off BLKANDNBLK*/  /* verilator lint_off MULTIDRIVEN*/  /* verilator lint_off WIDTHCONCAT*/  /* verilator lint_off ASSIGNDLY*/  /* verilator lint_off MODDUP*/  /* verilator lint_off STMTDLY*/  /* verilator lint_off LITENDIAN*/  /* verilator lint_off INITIALDLY*/  /* verilator lint_off UNUSED*/  

//Your Verilog/System Verilog Code Starts Here:
module Enc_8b10b_Ayush 
(
	input [8:0] Din,
	input Disparity_inp, // 0 = neg disp; 1 = pos disp
	output [9:0] Dout,
	output Disparity_out
);

wire ai = Din[0];
wire bi = Din[1];
wire ci = Din[2];
wire di = Din[3];
wire ei = Din[4];
wire fi = Din[5];
wire gi = Din[6];
wire hi = Din[7];
wire ki = Din[8];
	
wire aeqb = (ai & bi) | (!ai & !bi);
wire ceqd = (ci & di) | (!ci & !di);
wire l22  = (ai & bi & !ci & !di) |
				(ci & di & !ai & !bi) |
				(!aeqb   & !ceqd);
wire l40 = ai & bi & ci & di;
wire l04 = !ai & !bi & !ci & !di;
wire l13 = (!aeqb & !ci & !di) |
			  (!ceqd & !ai & !bi);
wire l31 = (!aeqb & ci & di) |
			  (!ceqd & ai & bi);

// ####################### The 5B/6B encoding ####################### //

wire ao = ai;
wire bo = (bi & !l40) | l04;
wire co = l04 | ci | (ei & di & !ci & !bi & !ai);
wire d0 = di & ! (ai & bi & ci);
wire eo = (ei | l13) & ! (ei & di & !ci & !bi & !ai);
wire io = (l22 & !ei) |
			 (ei & !di & !ci & !(ai&bi)) | // D16, D17, D18
			 (ei & l40) |
			 (ki & ei & di & ci & !bi & !ai) | // K.28
			 (ei & !di & ci & !bi & !ai);

// pds16 indicates cases where d-1 is assumed + to get our encoded value
wire pd1s6 = (ei & di & !ci & !bi & !ai) | (!ei & !l22 & !l31);
// nds16 indicates cases where d-1 is assumed - to get our encoded value
wire nd1s6 = ki | (ei & !l22 & !l13) | (!ei & !di & ci & bi & ai);
// ndos6 is pds16 cases where d-1 is + yields - disp out - all of them
wire ndos6 = pd1s6;
// pdos6 is nds16 cases where d-1 is - yields + disp out - all but one
wire pdos6 = ki | (ei & !l22 & !l13);
// some Dx.7 and all Kx.7 cases result in run length of 5 case unless
// an alternate coding is used (referred to as Dx.A7, normal is Dx.P7)
// specifically, D11, D13, D14, D17, D18, D19.
wire alt7 = fi & gi & hi & (ki | (Disparity_inp ? (!ei & di & l31) : (ei & !di & l13)));
wire fo = fi & ! alt7;
wire go = gi | (!fi & !gi & !hi);
wire ho = hi;
wire jo = (!hi & (gi ^ fi)) | alt7;

// nd1s4 is cases where d-1 is assumed - to get our encoded value
wire nd1s4 = fi & gi;
// pd1s4 is cases where d-1 is assumed + to get our encoded value
wire pd1s4 = (!fi & !gi) | (ki & ((fi & !gi) | (!fi & gi)));
// ndos4 is pd1s4 cases where d-1 is + yields - disp out - just some
wire ndos4 = (!fi & !gi);
// pdos4 is nd1s4 cases where d-1 is - yields + disp out
wire pdos4 = fi & gi & hi;

// only legal K codes are K28.0->.7, K23/27/29/30.7
//	K28.0->7 is ei=di=ci=1,bi=ai=0
//	K23 is 10111
//	K27 is 11011
//	K29 is 11101
//	K30 is 11110 - so K23/27/29/30 are ei & l31
wire illegalk = ki &
					(ai | bi | !ci | !di | !ei) & // not K28.0->7
					(!fi | !gi | !hi | !ei | !l31); // not K23/27/29/30.7

// now determine whether to do the complementing
// complement if prev disp is - and pd1s6 is set, or + and nd1s6 is set
wire compls6 = (pd1s6 & !Disparity_inp) | (nd1s6 & Disparity_inp);

// disparity out of 5b6b is disp in with pdso6 and ndso6
// pds16 indicates cases where d-1 is assumed + to get our encoded value
// ndos6 is cases where d-1 is + yields - disp out
// nds16 indicates cases where d-1 is assumed - to get our encoded value
// pdos6 is cases where d-1 is - yields + disp out
// disp toggles in all ndis16 cases, and all but that 1 nds16 case

wire disp6 = Disparity_inp ^ (ndos6 | pdos6);
wire compls4 = (pd1s4 & !disp6) | (nd1s4 & disp6);
assign Disparity_out = disp6 ^ (ndos4 | pdos4);
assign Dout = {(jo ^ compls4), (ho ^ compls4),
					  (go ^ compls4), (fo ^ compls4),
					  (io ^ compls6), (eo ^ compls6),
					  (d0 ^ compls6), (co ^ compls6),
					  (bo ^ compls6), (ao ^ compls6)};
	  
endmodule










//Top Module Code Starts here:
	module top();
		logic  [8:0] Din;//input
		logic  Disparity_inp;//input
		logic  [9:0] Dout;//output
		logic  Disparity_out;//output
//The $random() can be replaced if user wants to assign values
		assign Din = 9'b0;
		assign Disparity_inp = 1'b1;
		Enc_8b10b_Ayush Enc_8b10b_Ayush(.Din(Din), .Disparity_inp(Disparity_inp), .Dout(Dout), .Disparity_out(Disparity_out));
	
\TLV
//Add \TLV here if desired                                     
\SV
endmodule




















