`timescale 1ns/1ps

module tb_sar;

    reg clk;
    reg Start;
    reg [7:0] Vin;       
    wire [7:0] data;
    wire over;
    reg Comparator;

    
    SAR uut (
        .clk(clk),
        .Comparator(Comparator),
        .Start(Start),
        .data(data),
        .over(over)
    );

   
    initial clk = 0;
    always #5 clk = ~clk;

    always @(*) begin
        if (uut.converting) begin
            
            if (Vin >= data)
                Comparator = 1;   
            else
                Comparator = 0;   
        end else begin
            Comparator = 0; 
        end
    end

    
    initial begin
        $dumpfile("tb_sar.vcd");
        $dumpvars(0, tb_sar);

        
        Start = 0;
        Vin   = 8'd165;   
        #20;

        
        Start = 1;
        #10 Start = 0;

        
        wait(over);
        $display("Conversion finished: Vin=%0d, Digital Out=%0d (bin=%b)", Vin, data, data);

        #50 $finish;
    end

endmodule
