module ksa_4bit(a,b,y);
	input [3:0] a;
	input [3:0] b;
	output [4:0] y;

	wire [3:0] g;
	wire [3:0] p;
	wire [3:0] h;

	wire g11,g12,g21,g22;
	wire p12;

	generate
		genvar i;
		for (i = 0; i < 4; i = i + 1)
		begin:pgh_block
			assign p[i] = a[i] | b[i];
			assign g[i] = a[i] & b[i];
			assign h[i] = a[i] ^ b[i];
		end
	endgenerate

	//layer - 1
	grey_circle  gc11(.gi(g[1]),.pi(p[1]),.gj(g[0]),.gk(g11));
	black_circle bc11(.gi(g[3]),.pi(p[3]),.gj(g[2]),.pj(p[2]),.gk(g12),.pk(p12));

	//layer - 2
	grey_circle  gc21(.gi(g[2]),.pi(p[2]),.gj(g11),.gk(g21));
	grey_circle  gc22(.gi(g12),.pi(p12),.gj(g11),.gk(g22));

	//sum
	assign y[0] = h[0] ^ 0;
	assign y[1] = h[1] ^ g[0];
	assign y[2] = h[2] ^ g11;
	assign y[3] = h[3] ^ g21;
	assign y[4] = g22;

endmodule 
