# 3-bit-FLASH-ADC-using-eSim

- [Abstract](#abstract)
- [Reference Circuit Diagram](#reference-circuit-diagram)
- [Circuit Details](#circuit-details)
- [Methodology](#methodology)
- [Software Used](#software-used)
- [Verilog Code](#verilog-code)
- [MakerChip](#makerchip)
- [Waveform](#waveform)
- [Model for Ex-OR gate](#model-for-ex-or-gate)
- [Schematics](#schematics)
- [Netlist](#netlist)
- [Output Waveform](#output-waveform)
- [Author](#author)
- [Acknowledgements](#acknowledgements)
- [Reference](#reference)

<small><i><a href='http://ecotrust-canada.github.io/markdown-toc/'>Table of contents generated with markdown-toc</a></i></small>

# Abstract

Flash ADC is also known as the parallel A/D converter. It is formed of a series of comparators, each one comparing the input signal to an unique reference voltage. The comparator outputs connect to the inputs of a priority encoder circuit built with gates and diode which then produces a binary output. Flash converters are extremely fast compared to many other types of ADCs. This paper explains the simulation of flash adc using eSim.


# Reference Circuit Diagram
![image](https://user-images.githubusercontent.com/83063776/157719067-27d66cbc-f67b-4cdd-b330-a87750c5053a.png)

# Circuit Details

This three-bit flash ADC requires seven comparators. A four-bit version would require 15 comparators. With each additional output bit, the number of required comparators doubles.
It has seven op-amps and seven Exclusive-OR gates. Vref is a stable reference voltage provided by a precision voltage regulator as part of the converter circuit and Vin is given as 5V.
The Vref used here is PWL wave and its connected to non – inverting terminal of the op-amp.

# Methodology
 
Verilog code for Ex-OR Gate is created and simulated using
MakerChip. The Code is dumped in Ngveri and model is created.
Schematics is drawn on eSim. Generating Netlist for the mixed signal circuit. Kicad to Ngspice conversion is done by adding simulation parameters for the circuit. Simulation is done.

# Software Used
eSim:

It is an Open Source EDA developed by FOSSEE, IIT Bombay. It is used for electronic circuit simulation. It is made by the combination of two software namely NgSpice and KiCAD.
For more details refer:
https://esim.fossee.in/home

NgSpice:

It is an Open Source Software for Spice Simulations. For more details refer:
http://ngspice.sourceforge.net/docs.html

Makerchip:

It is an Online Web Browser IDE for Verilog/System-verilog/TL-Verilog Simulation. Refer
https://www.makerchip.com/

Verilator:

It is a tool which converts Verilog code to C++ objects. Refer: https://www.veripool.org/verilator/

# Verilog Code
![image](https://user-images.githubusercontent.com/83063776/157718331-dc1a6231-5914-4508-8b07-82a766de64ce.png)

# MakerChip
Code:

\TLV_version 1d: tl-x.org
\SV
/* verilator lint_off UNUSED*/  /* verilator lint_off DECLFILENAME*/  /* verilator lint_off BLKSEQ*/  /* verilator lint_off WIDTH*/  /* verilator lint_off SELRANGE*/  /* verilator lint_off PINCONNECTEMPTY*/  /* verilator lint_off DEFPARAM*/  /* verilator lint_off IMPLICIT*/  /* verilator lint_off COMBDLY*/  /* verilator lint_off SYNCASYNCNET*/  /* verilator lint_off UNOPTFLAT */  /* verilator lint_off UNSIGNED*/  /* verilator lint_off CASEINCOMPLETE*/  /* verilator lint_off UNDRIVEN*/  /* verilator lint_off VARHIDDEN*/  /* verilator lint_off CASEX*/  /* verilator lint_off CASEOVERLAP*/  /* verilator lint_off PINMISSING*/   /* verilator lint_off BLKANDNBLK*/  /* verilator lint_off MULTIDRIVEN*/    /* verilator lint_off WIDTHCONCAT*/  /* verilator lint_off ASSIGNDLY*/  /* verilator lint_off MODDUP*/  /* verilator lint_off STMTDLY*/  /* verilator lint_off LITENDIAN*/  /* verilator lint_off INITIALDLY*/

//Your Verilog/System Verilog Code Starts Here:
module samyuktha_flashadc(c,a,b);
input a,b;
output c;
xor (c,a,b);
endmodule

//Top Module Code Starts here:
	module top(input logic clk, input logic reset, input logic [31:0] cyc_cnt, output logic passed, output logic failed);
		logic  a;//input
		logic  b;//input
		logic  c;//output
//The $random() can be replaced if user wants to assign values
		assign a = $random();
		assign b = $random();
		samyuktha_flashadc samyuktha_flashadc(.a(a), .b(b), .c(c));
	
\TLV
//Add \TLV here if desired                                     
\SV
endmodule

# Waveform
![image](https://user-images.githubusercontent.com/83063776/157719432-7f1d4459-dc38-4f22-ad9c-3cbf6008b4fc.png)

# Model for Ex-OR gate
![image](https://user-images.githubusercontent.com/83063776/157719490-0f21103e-c693-40ac-8c94-7b189340984f.png)

# Schematics
![image](https://user-images.githubusercontent.com/83063776/157719559-9a1bf394-6278-48be-b079-35a572a75a5e.png)

# Netlist
https://github.com/SamyukthaShrruthiKR-2907/3-bit-FLASH-ADC-using-eSim-/blob/main/eSim%20Project%20Files/flashadc.cir.out

# Output Waveform
![image](https://user-images.githubusercontent.com/83063776/157719847-5b3f9b1c-8616-4f1c-995f-260325b5adc7.png)

# Author
Samyuktha Shrruthi K R

Pre-Final Year B.E. ECE

Easwari Engineering College

Mail : samyukthashrruthi@gmail.com

# Acknowledgements
1.	Kunal Ghosh (Co-Founder, VLSI System Design Pvt. Ltd.)
2.	FOSSEE, IIT Bombay
3.	Steve Hoover (Founder, Redwood EDA)
4.	Sumanto Kar (eSim Team, FOSSEE, IIT Bombay)
	
# Reference
1.	“Design of 3-bit Current mode Flash ADC” by Jyoti,Pallavi Bansal
2.	“Design and Analysis of a Comparator for Flash ADC” by Senthil Sivakumar M, Sowmya Priya M
3.	https://instrumentationtools.com/topic/flash-adc/


